/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xlnk;

import java.util.Vector;
import uk.co.demon.obelisk.xlnk.Region;
import uk.co.demon.obelisk.xobj.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Area {
    private Vector<Region> regions = new Vector();

    public Area(String location) {
        String[] pairs = location.split(",");
        int index = 0;
        while (index < pairs.length) {
            String[] addrs = pairs[index].split("-");
            Region region = new Region(addrs[0], addrs[1]);
            boolean handled = false;
            int position = 0;
            while (position < this.regions.size()) {
                Region other = this.regions.elementAt(position);
                if (region.getStart() < other.getStart()) {
                    this.regions.insertElementAt(region, position);
                    handled = true;
                    break;
                }
                ++position;
            }
            if (!handled) {
                this.regions.add(region);
            }
            ++index;
        }
    }

    public Vector<Region> getRegions() {
        return this.regions;
    }

    public long getLoAddr() {
        return this.regions.firstElement().getStart();
    }

    public long getHiAddr() {
        return this.regions.lastElement().getEnd();
    }

    public long fitSection(Section section) {
        long addr = -1L;
        int size = section.getSize();
        if (section.isAbsolute()) {
            addr = section.getStart();
            int index = 0;
            while (index < this.regions.size()) {
                Region region = this.regions.elementAt(index);
                if (region.getStart() <= addr && addr + (long)size <= region.getEnd()) {
                    if (region.getStart() == addr) {
                        region.reserve(size);
                    } else {
                        region = region.split(addr);
                        this.regions.insertElementAt(region, index + 1);
                        region.reserve(size);
                    }
                }
                ++index;
            }
        } else {
            int index = 0;
            while (index < this.regions.size()) {
                Region region = this.regions.elementAt(index);
                if (region.getSize() >= size) {
                    addr = region.getStart();
                    region.reserve(size);
                    break;
                }
                ++index;
            }
        }
        return addr;
    }
}

